<?php
class TripDL extends Config {
public function add($params) {
        try
        {
            $stmt = $this
                ->conn
                ->prepare("insert into trips(trip_name,trip_date,vehicle_id,vehicle_name,trip_advance,trip_diesel,created_date) 
			values 
			(:trip_name,:trip_date,:vehicle_id,:vehicle_name,:trip_advance,:trip_diesel,:created_date)");
            $stmt->execute($params);
            $last_id = $this
                ->conn
                ->lastInsertId();
            return $last_id;
	}
	catch(PDOException $e)
        {
            echo $e->getMessage();
        }
}
public function modify($params) {
	$status = "0";
        try
        {
            $stmt = $this
                ->conn
                ->prepare("update trips set trip_name=:trip_name,trip_date=:trip_date,vehicle_id=:vehicle_id,vehicle_name=:vehicle_name,trip_advance=:trip_advance,trip_diesel=:trip_diesel where trip_id = :trip_id"); 
            $stmt->execute($params);
	$status = $stmt->rowCount();

	}
	catch(PDOException $e)
        {
            echo $e->getMessage();
        }
	return $status;
}
public function delete($params) {
	$status = 0;
        try
        {
            $stmt = $this
                ->conn
                ->prepare("delete from trips where trip_id = :trip_id"); 
            $stmt->execute($params);
		$status = $stmt->rowCount();
	}
	catch(PDOException $e)
        {
            echo $e->getMessage();
        }
	return $status;
}


public function getTripById($params) {
	$ret_val = array();
        try
        {
            $stmt = $this
                ->conn
                ->prepare("select ct.* 
                from trips ct 
                where ct.trip_id = :trip_id");
            	$stmt->execute($params);
        	$row = $stmt->fetch();
        	$ret_val = $row;
	}
	catch(PDOException $e)
        {
            echo $e->getMessage();
        }
	return $ret_val;
}
public function getAllTrip()
    {
        $stmt = $this
            ->conn
            ->prepare("select ct.* 
                from trips ct");
        $stmt->execute();
        $data = $stmt->fetchAll();
        return $data;
    }
   

    public function getAllTripByMonthYear($month,$year)
    {
        $stmt = $this
            ->conn
            ->prepare("select ct.* where  month(ct.trip_date)=:month and year(ct.trip_date)=:year order by ct.trip_date desc");
        $stmt->bindParam(":month", $month, PDO::PARAM_INT);
        $stmt->bindParam(":year", $year, PDO::PARAM_INT);
        $stmt->execute();
        $data = $stmt->fetchAll();
        return $data;
    }
public function getAllTripByDateRange($from_date, $to_date)
    {
        $stmt = $this
            ->conn
            ->prepare("select ct.* 
            from 
            trips ct 
            where ct.trip_date between :from_date and :to_date  order ct.trip_date");
        $stmt->bindParam(":from_date", $from_date);
        $stmt->bindParam(":to_date", $to_date);
        $stmt->bindParam(":cmp_id", $cmp_id, PDO::PARAM_INT);
        $stmt->execute();
        $data = $stmt->fetchAll();
        return $data;
    }
}

?>