<?php
include '../Config.php';
include '../Data/tripDL.php';
$trip = new TripDL();
$ret_val = [];
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = json_decode(file_get_contents('php://input'), true);
    $act = $data["act"];
    if ($act == "add") {
        $trip_name = $data["trip_name"];
        $trip_date = $data["trip_date"];
        $vehicle_id = $data["vehicle_id"];
	    $vehicle_name = $data["vehicle_name"];
        $trip_advance = $data["trip_advance"];
        $trip_diesel = $data["trip_diesel"];
        $created_date = $data["created_date"];

        $params = [
            ":trip_name" => $trip_name,
            ":trip_date" => $trip_date,
	        ":vehicle_id" => $vehicle_id,
            ":vehicle_name" => $vehicle_name,
            ":trip_advance" => $trip_advance,
            ":trip_diesel" => $trip_diesel,
            ":created_date" => $created_date
           
        ];
        try {
            $trip_id = $trip->add($params);
            $ret_val = ["status" => 1, "message" => "trip data stored!", "data" => $trip_id];
        } catch (PDOException $ex) {
            $ret_val = ["status" => 1, "message" => $ex->getMessage(), "data" => null];
        }
    } else {
        $ret_val = ["status" => 0, "message" => "Invalid mode", "data" => null];
    }
    echo json_encode($ret_val);
} elseif ($_SERVER['REQUEST_METHOD'] === 'PUT') {
    $data = json_decode(file_get_contents('php://input'), true);
    $act = $data["act"];
    if ($act == "mod") {
        $trip_name = $data["trip_name"];
        $trip_date = $data["trip_date"];
        $vehicle_id = $data["vehicle_id"];
	    $vehicle_name = $data["vehicle_name"];
        $trip_advance = $data["trip_advance"];
        $trip_diesel = $data["trip_diesel"];
    	$trip_id=$data["trip_id"];

       $params = [
            ":trip_name" => $trip_name,
            ":trip_date" => $trip_date,
	        ":vehicle_id" => $vehicle_id,
            ":vehicle_name" => $vehicle_name,
            ":trip_advance" => $trip_advance,
            ":trip_diesel" => $trip_diesel,
            ":trip_id" => $trip_id
        ];

        try {
            $status = $trip->modify($params);
            $ret_val = ["status" => 1, "message" => "trip data MODIFIED!", "data" => $trp_id];
        } catch (PDOException $e) {
            $ret_val = ["status" => 0, "message" => $e->getMessage(), "data" => null];
        } catch (Exception $e) {
            $ret_val = ["status" => 0, "message" => $e->getMessage(), "data" => null];
        }
    } else {
        $ret_val = ["status" => 0, "message" => "Invalid mode", "data" => null];
    }

    echo json_encode($ret_val);
} elseif ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $act = $_REQUEST["act"];
    if ($act == "All") {
        $month = $_REQUEST["month"];
        $year = $_REQUEST["year"];
        $data = [];
        $response = $trip->getAllTripByMonthYear($month, $year);
        foreach ($response as $row) {
            $data[] = $row;
        }
        $json = json_encode($data);
    } else {
        $trip_id = $_REQUEST["trip_id"];
        $data = $trip->getCompanyTripById([":trip_id" => $trip_id]);
        $json = json_encode($data);
    }
    echo $json;
} elseif ($_SERVER['REQUEST_METHOD'] === 'DELETE') {
    try {
        $trip_id = $_REQUEST["trip_id"];

        $params = [
            ":trip_id" => $trip_id,
        ];

        $rows = $trip->delete($params);
        if ($rows > 0) {
            $ret_val = ["status" => 1, "message" => "Data deleted.", "data" => $rows];
        } else {
            $ret_val = ["status" => 0, "message" => "No rows deleted.", "data" => null];
        }
    } catch (Exception $e) {
        $ret_val = ["status" => 0, "message" => $e->getMessage(), "data" => null];
    } catch (PDOException $e) {
        $ret_val = ["status" => 0, "message" => $e->getMessage(), "data" => null];
    }

    echo json_encode($ret_val);
} else {
    $ret_val = ["status" => 0, "message" => "Invalid call ....", "data" => "0"];
    echo json_encode($ret_val);
}
?>
